#include "deds/string.h"
#include <string.h>
#include <assert.h>

/** !Construct a MX_STRING
This function initializes a MX_STRING object.  It writes the memory
full with 0 values. */
void mx_string(MX_STRING * string)
{
	assert(string);

	/** Since a MX_STRING filled with 0 is correctly constructed then
    static instances dont necessarily have to be constructed before use. */
	memset(string, 0, sizeof(*string));
}

/** !Destruct a MX_STRING
This function frees a MX_STRING object.  If the associated free
will be called to release any internal memory. */
void mx_string_free(MX_STRING * string)
{
	assert(string);

	if ((string->_text) && (string->_free))
		string->_free((void *) string->_text);

	memset(string, 0, sizeof(*string));
}

/*
   DEDS
   Data structures and utility functions for C
   Copyright (C) 2006 Douglas Eleveld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
