/** !Rectangles with reference counting.

This module contains code for MX_RECTATOM which is a MX_RECT with
reference counting.  The reference counting is done my deriving MX_RECTATOM
from MX_ATOM.  Additional macros exist for reading rectangle positioning and 
dimensions. */

#ifndef MX__DEDS_RECTATOM_HEADER
#   define MX__DEDS_RECTATOM_HEADER

#   include <stdlib.h>
#   include "deds/atom.h"
#   include "deds/rect.h"

#   ifdef __cplusplus
extern "C" {
#   endif
/** !MX_RECT with reference counting */ typedef struct MX_RECTATOM_DATA {
		union {
			MX_ATOM atom;
		} base;

		MX_RECT _rect;
	} MX_RECTATOM_DATA;

	typedef struct MX_RECTATOM {
		union {
			MX_RECTATOM_DATA rectatom;
			MX_ATOM atom;
		} base;
	} MX_RECTATOM;

#   define MXRECTATOM(b)   (&(b)->base.rectatom)

/** !Typesafe conversion between a class derived from MX_RECTATOM to a MX_RECT. */
#   define MXRECT(b) ((const MX_RECT *)(&(b)->base.rectatom._rect))

	void *mx__rectatom(MX_RECTATOM_DATA * rectatom, MX__ATOM_DESTRUCT destruct, size_t size);

/**func !Construct a MX_RECTATOM */
#   define mx_rectatom(r,d,s) mx__rectatom(MXRECTATOM(r), (d), (s))

	void mx__rectatom_place(MX_RECTATOM_DATA * rectatom, const MX_RECT * rect);

/** !Place a MX_RECTAOM at some specific rectangle. */
#   define mx_rectatom_place(r, rect) mx__rectatom_place(MXRECTATOM(r), (rect))

/** !MX_RECTATOM x1 value. */
#   define mx_x1(r) ((const int)((r)->base.rectatom._rect.x1))

/** !MX_RECTATOM y1 value. */
#   define mx_y1(r) ((const int)((r)->base.rectatom._rect.y1))

/** !MX_RECTATOM x2 value. */
#   define mx_x2(r) ((const int)((r)->base.rectatom._rect.x2))

/** !MX_RECTATOM y2 value. */
#   define mx_y2(r) ((const int)((r)->base.rectatom._rect.y2))

/** !MX_RECTATOM width. */
#   define mx_w(r)  ((const int)((r)->base.rectatom._rect.x2 - (r)->base.rectatom._rect.x1))

/** !MX_RECTATOM height. */
#   define mx_h(r)  ((const int)((r)->base.rectatom._rect.y2 - (r)->base.rectatom._rect.y1))

#   ifdef __cplusplus
}
#   endif
#endif
/*
   DEDS
   Data structures and utility functions for C
   Copyright (C) 2006 Douglas Eleveld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
