/** !Simple macros for maximum and minimum of two values.

In this module we declate macros to the maximum and minimum of two
values.  This avoids potential conflicts with other libraries. */

#ifndef MX__DEDS_MAXMIN_HEADER
#define MX__DEDS_MAXMIN_HEADER

#ifdef __cplusplus
extern "C" {
#endif

/** !The maximum of two values. */
#define MX_MAX(x,y)     (((x) > (y)) ? (x) : (y))

/** !The minimum of two values. */
#define MX_MIN(x,y)     (((x) < (y)) ? (x) : (y))

/** !The middle of three values. */
#define MX_MID(x,y,z) ((x)>(y)?((y)>(z)?(y):((x)>(z)?(z):\
                       (x))):((y)>(z)?((z)>(x)?(z):(x)):(y)))

/**author MX_MID macro taken from the Allegro developers mailing list
         (submitted by Matthew Leverton) */

#ifdef __cplusplus
}
#endif
#endif
/*
    DEDS
    Data structures and utility functions for C
    Copyright (C) 2006 Douglas Eleveld

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
