/*--------------------------------------------------------------------------
 DEPUI-GFX-TK 3.0 - GPL portable source code libraries 
 http://www.deleveld.dds.nl/depui.htm
 See file docs/copying for copyright details
 ---------------------------------------------------------------------------*/

#define MXMODULE_THEME_ROUNDED
#define MXMODULE_LIST
#include "depui/depui.c"

typedef struct APP {
	union {
		MX_WIN_DATA win;
		MX_TEXTUAL_DATA textual;
		MX_OBJ_DATA obj;
		MX_RECTATOM_DATA rectatom;
		MX_ATOM atom;
	} base;
	MX_LIST list;
	MX_BUTTON apply;
	MX_BUTTON close;
} APP;

static void handler(MX_WIN * win)
{
	APP *app = (APP *) win;

	/* Place the objects in a nice place when geometry is set */
	if ((mx.event == MX_GEOMETRY) && (MXOBJ(mx.obj) == MXOBJ(win))) {

		/* Close button in lower right */
		mx_layout(&app->close, (MX_LAYOUT) (MX_LAYOUT_X2 | MX_LAYOUT_Y2), app,
				  -2, -2);

		/* Apply button to left of close button */
		mx_layout(&app->apply, (MX_LAYOUT) (MX_LAYOUT_LEFT | MX_LAYOUT_Y1),
				  &app->close, 2, 0);

		/* The remainig space is for the list */
		mx_move(&app->list, 2, 2);
		mx_resize(&app->list, mx_w(app) - 4, mx_y(&app->close) - 5);
		mx_geometry(&app->list);
	}

	/* Change the title of the window when apply is clicked */
	if ((mx.event == MX_SELECT) && (mx.data)
		&& (MXOBJ(mx.obj) == MXOBJ(&app->apply))) {

		const MX_LISTELEM *last = mx_list_selected(&app->list, (MX_LISTELEM *)0);

		if (last) {
			int len;
			const char *text = mx_text(last, &len);

			/* We need to do this before and after because the new window
			   border might be smaller with the new title */
			mx_win_dirty(app);

			mx_text_set(app, text, len, 0);
			mx_geometry(app);

			mx_win_dirty(app);
		}
		/* Dont let the apply button toggle */
		return;
	}

	/* Close when the ok button is set */
	if ((mx.event == MX_SELECT) && (MXOBJ(mx.obj) == MXOBJ(&app->close)))
		mx_delete(app);

	mx_win_handler(win);
}

static APP *newapp(void)
{
	/* Create the window for the app */
	APP *app = (APP *) mx_win((MX_WIN*)0, sizeof(APP), handler, 0);

	if (app) {
		MX_GUIFONT *font;
		MX_LISTELEM *elem;

		font = mx_guifont_index(2);

		/* Make a list and fill it with some titles */
		mx_list(&app->list, 0, app, 0);
/**fix		mx_text_set(&app->list, "Choose a title", -1, 0); */

		elem = mx_list_append(&app->list, "Title 1", -1, 0, 0);
		mx_text_font(elem, font);
		elem =
			mx_list_append(&app->list, "This entry is\n2 lines long", -1, 0, 0);
		mx_text_font(elem, font);
		elem = mx_list_append(&app->list, "Title 3", -1, 0, 0);
		mx_text_font(elem, font);
		elem = mx_list_append(&app->list, "Title 4", -1, 0, 0);
		mx_text_font(elem, font);
		elem = mx_list_append(&app->list, "Title 5", -1, 0, 0);
		mx_text_font(elem, font);
		elem = mx_list_append(&app->list, "Title 6", -1, 0, 0);
		mx_text_font(elem, font);
		elem = mx_list_append(&app->list, "Title 7", -1, 0, 0);
		mx_text_font(elem, font);
		elem = mx_list_append(&app->list, "Title 8", -1, 0, 0);
		mx_text_font(elem, font);
		elem = mx_list_append(&app->list, "Title 9", -1, 0, 0);
		mx_text_font(elem, font);
		elem = mx_list_append(&app->list, "Title 10", -1, 0, 0);
		mx_text_font(elem, font);

		/* Make a close and apply button */
		mx_button(&app->close, 0, app, 0);
		mx_text_set(&app->close, "Close", -1, 0);
		mx_defaultrect(&app->close, 0);

		mx_button(&app->apply, 0, app, 0);
		mx_text_set(&app->apply, "Apply", -1, 0);
		mx_defaultrect(&app->apply, 0);
	}
	return app;
}

int main(int argc, char *argv[])
{
	APP *app;
	MX_GUIFONT *font;

	(void) argc;
	(void) argv;

	if (!mx_start())
		return EXIT_FAILURE;

	font = mx_guifont_load("./font/arial2.pcx", "");
	mx_guifont_default(font);

	app = newapp();
	assert(app);

	mx_position(app, 50, 50, 200, 250);
	mx_text_set(app, "App title", -1, 0);
	mx_geometry(app);

	return mx_execute();
}
