/*--------------------------------------------------------------------------
 DEPUI-GFX-TK 3.0 - GPL portable source code libraries 
 http://www.deleveld.dds.nl/depui.htm
 See file docs/copying for copyright details
 ---------------------------------------------------------------------------*/

#define MXMODULE_SYSMENU
#include "depui/depui.c"

typedef struct APP {
	union {
		MX_WIN_DATA win;
		MX_TEXTUAL_DATA textual;
		MX_OBJ_DATA obj;
		MX_RECTATOM_DATA rectatom;
		MX_ATOM atom;
	} base;
	MX_BUTTON toggle;
} APP;

static void handler(MX_WIN * win)
{
	APP *app = (APP *) win;

	if ((mx.event == MX_SELECT) && (MXOBJ(mx.obj) == MXOBJ(&app->toggle))) {

		if (mx.data)
			mx_text_set(app, "Toggle is on", -1, 0);
		else
			mx_text_set(app, "Toggle is off", -1, 0);

		mx_win_dirty(win);
	}

	mx_win_handler(win);
}

int main(int argc, char *argv[])
{
	APP *app;

	(void) argc;
	(void) argv;

	if (!mx_start())
		return EXIT_FAILURE;

	mx_sysmenu();

	app = (APP *) mx_win((MX_WIN *)0, sizeof(APP), handler, 0);
	assert(app);

	mx_position(app, 50, 50, 200, 250);
	mx_text_set(app, "Press button", -1, 0);
	mx_geometry(app);

	mx_button(&app->toggle, 0, app, 0);
	mx_text_set(&app->toggle, "Toggle", -1, 0);
	mx_move(&app->toggle, 10, 10);
	mx_defaultrect(&app->toggle, 0);
	mx_text_align(&app->toggle, MX_ALIGN_CENTER);

	return mx_execute();
}
