/*--------------------------------------------------------------------------
 DEPUI-GFX-TK 3.0 - GPL portable source code libraries 
 http://www.deleveld.dds.nl/depui.htm
 See file docs/copying for copyright details
 ---------------------------------------------------------------------------*/

#define MXMODULE_BITLINE
#define MXMODULE_FONTDRAW
#include "degfx/degfx.c"

static char message[200];

static void draw_intro(const MX_RECT * r)
{
	mx_rectfill(r->x1, r->y1, r->x2, r->y2, MXCOLOR_mediumslateblue);

	mx_font_drawblock(0, message, -1, 1, 5, MXCOLOR_white);
}

int main(int argc, char *argv[])
{
	(void) argc;
	(void) argv;

	/* Start the graphic system */
	if (!mx_gfx_start(0))
		return 1;

	/* Draw the intro screen */
	sprintf(message,
			"Welcome to the DEGFX library\n\n" "    Driver: %s\n"
			"\nPress key to continue", mx_gfx_info()->title);
	mx_gfx_redraw(draw_intro);

	while (mx_gfx_poll()) {
		int scan;
		int ascii;

		if (mx_gfx_key(&scan, &ascii)) {
			sprintf(message, "Last key %i %i \'%c\'", (int) scan, (int) ascii,
					(char) ascii);
			mx_gfx_dirty(0);

			if (ascii == 27)
				break;
		}
	}

	mx_gfx_stop();
	return 0;
}
