/*--------------------------------------------------------------------------
 DEPUI-GFX-TK 3.0 - GPL portable source code libraries 
 http://www.deleveld.dds.nl/depui.htm
 See file docs/copying for copyright details
 ---------------------------------------------------------------------------*/

#include "degfx/degfx.c"

static void draw(const MX_RECT * r)
{
	int i, j;

	/* For each row to display */
	for (i = r->y1; i <= r->y2; i++) {

		/* Get bitmap iterators for the row */
		MX_BITMAP_ITER start = mx_bitmap_iter(MXSCREEN, r->x1, i);
		const MX_BITMAP_ITER end = mx_bitmap_iter(MXSCREEN, r->x2, i) + 1;

		/* Put a checkerboard pattern on the screen */
		j = r->x1;
		while (start != end) {
			if ((i & 0x01) && (j & 0x01))
				*start = MXCOLOR_white;
			else
				*start = MXCOLOR_black;

			++start;
			++j;
		}
	}
}

int main(int argc, char *argv[])
{
	(void) argc;
	(void) argv;

	/* Start the graphic system */
	if (!mx_gfx_start(0))
		return 1;

	/* Tell what the redraw funtion is */
	mx_gfx_redraw(draw);

	/* Loop until key is pressed */
	while (mx_gfx_poll()) {

		/* Move the pointer */
		mx_gfx_pointer(0, 0, 0);

		if (mx_gfx_key(0, 0))
			break;
	}

	return 0;
}
