/*--------------------------------------------------------------------------
 DEPUI-GFX-TK 3.0 - GPL portable source code libraries 
 http://www.deleveld.dds.nl/depui.htm
 See file docs/copying for copyright details
 ---------------------------------------------------------------------------*/

#define MXMODULE_BITLINE
#define MXMODULE_LOADTGA
#include "degfx/degfx.c"

#include <time.h>

static MX_BITMAP *bitmap;

static void draw(const MX_RECT * r)
{
	/* Draw a background */
	mx_rectfill(r->x1, r->y1, r->x2, r->y2, MXCOLOR_lightskyblue3);

	/* Draw the bitmap on the screen */
	mx_blit(bitmap, 0, 0, 0, 0, MXDEFAULT, MXDEFAULT);
	mx_blit(bitmap, 0, 0, 50, 10, MXDEFAULT, MXDEFAULT);
	mx_blit(bitmap, 0, 0, 100, 20, MXDEFAULT, MXDEFAULT);
}

int main(int argc, char *argv[])
{
	unsigned i;

	(void) argc;
	(void) argv;

	/* Start the graphic system */
	if (!mx_gfx_start(0))
		return 1;

	/* Load in the bitmap */
	bitmap = mx_bitmap_tga("title.tga");
	if (!bitmap)
		return 2;

	/* Make the bitmap pixels transparent */
	for (i = 0; i <= (unsigned) mx_h(bitmap); i++) {
		MX_BITMAP_ITER start = mx_bitmap_iter(bitmap, 0, i);
		const MX_BITMAP_ITER end = mx_bitmap_iter(bitmap, mx_w(bitmap), i);

		while (start != end) {
			*start = MXTRANS(*start, (i * 0xff) / mx_h(bitmap));
			++start;
		}
	}

	/* Tell what the redraw funtion is */
	mx_gfx_redraw(draw);

	/* Main loop */
	while (mx_gfx_poll()) {

		/* Move the pointer */
		mx_gfx_pointer(0, 0, 0);

		/* Exit when key is hit */
		if (mx_gfx_key(0, 0))
			break;
	}

	/* Free the bitmap */
	mx_delete(bitmap);

	return 0;
}
