/*--------------------------------------------------------------------------
 DEPUI-GFX-TK 3.0 - GPL portable source code libraries 
 http://www.deleveld.dds.nl/depui.htm
 See file docs/copying for copyright details
 ---------------------------------------------------------------------------*/

#define MXMODULE_BITLINE
#define MXMODULE_LOADTGA
#include "degfx/degfx.c"

#include <time.h>

int x, y, dx, dy;
static MX_BITMAP *bitmap;

static void draw(const MX_RECT * r)
{
	/* Draw a background */
	mx_rectfill(r->x1, r->y1, r->x2, r->y2, MXCOLOR_lightskyblue3);

	/* Draw the bitmap on the screen */
	mx_blit(bitmap, 0, 0, x, y, MXDEFAULT, MXDEFAULT);
}

int main(int argc, char *argv[])
{
	(void) argc;
	(void) argv;

	/* Start the graphic system */
	if (!mx_gfx_start(0))
		return 1;

	/* Load in the bitmap */
	bitmap = mx_bitmap_tga("title.tga");
	if (!bitmap)
		return 2;

	/* Start it in the upper left */
	x = 0;
	y = 0;
	dx = 1;
	dy = 1;

	/* Tell what the redraw funtion is */
	mx_gfx_redraw(draw);

	/* Main loop */
	while (mx_gfx_poll()) {
		MX_RECT rect;

		/* Get some screen info */
		const MX_GFX_ARGS *info = mx_gfx_info();
		const MX_RECT *screen = &info->screen;

		/* Move the pointer */
		mx_gfx_pointer(0, 0, 0);

		/* Exit when key is hit */
		if (mx_gfx_key(0, 0))
			break;

		/* Update where the bitmap was */
		rect = *MXRECT(bitmap);
		rect.x1 += x;
		rect.y1 += y;
		rect.x2 += x;
		rect.y2 += y;
		mx_gfx_dirty(&rect);

		/* Move the bitmap */
		x += dx;
		y += dy;

		/* Keep the bitmap on the screen */
		if (x < screen->x1)
			dx *= -1;
		if (x + mx_w(bitmap) > screen->x2)
			dx *= -1;

		if (y < screen->y1)
			dy *= -1;
		if (y + mx_h(bitmap) > screen->y2)
			dy *= -1;

		/* Update where the bitmap is now */
		rect = *MXRECT(bitmap);
		rect.x1 += x;
		rect.y1 += y;
		rect.x2 += x;
		rect.y2 += y;
		mx_gfx_dirty(&rect);
	}

	/* Free the bitmap */
	mx_delete(bitmap);

	return 0;
}
