/*--------------------------------------------------------------------------
 DEPUI-GFX-TK 3.0 - GPL portable source code libraries 
 http://www.deleveld.dds.nl/depui.htm
 See file docs/copying for copyright details
 ---------------------------------------------------------------------------*/

#define MXMODULE_BITLINE
#define MXMODULE_LOADTGA
#define MXMODULE_LOADGIF
#define MXMODULE_BITDRAW
#include "degfx/degfx.c"

static MX_BITMAP *bitmap;

static void draw(const MX_RECT * r)
{
	/* Draw a background */
	mx_rectfill(r->x1, r->y1, r->x2, r->y2, MXCOLOR_lightskyblue3);

	/* Draw the bitmap on the screen */
	mx_blit(bitmap, 0, 0, 0, 0, MXDEFAULT, MXDEFAULT);

	mx_blittrans(bitmap, 0, 0, 50, 30, MXDEFAULT, MXDEFAULT, 64);
	mx_blittrans(bitmap, 0, 0, 100, 60, MXDEFAULT, MXDEFAULT, 128);
}

int main(int argc, char *argv[])
{
	(void) argc;
	(void) argv;

	/* Start the graphic system */
	if (!mx_gfx_start(0))
		return 1;

	/* Load in the bitmap */
	/* bitmap = mx_bitmap_tga("title.tga"); */
	bitmap = mx_bitmap_gif("title.gif");
	if (!bitmap)
		return 2;

	/* Tell what the redraw funtion is */
	mx_gfx_redraw(draw);

	/* Loop until key is pressed */
	while (mx_gfx_poll()) {
		/* Move the pointer */
		mx_gfx_pointer(0, 0, 0);

		/* Exit when key is hit */
		if (mx_gfx_key(0, 0))
			break;
	}

	/* Free the bitmap */
	mx_delete(bitmap);

	return 0;
}
