/*--------------------------------------------------------------------------
 DEPUI-GFX-TK 3.0 - GPL portable source code libraries 
 http://www.deleveld.dds.nl/depui.htm
 See file docs/copying for copyright details
 ---------------------------------------------------------------------------*/

#define MXMODULE_DRIVER_VGA
#define MXMODULE_BITLINE
#define MXMODULE_FONTDRAW
#include "degfx/degfx.c"

static void draw(const MX_RECT * r)
{
	/* Draw a background */
	mx_rectfill(r->x1, r->y1, r->x2, r->y2, MXCOLOR_wheat);

	/* Draw the welcome message */
	mx_font_draw(0, "Welcome to DEGFX", -1, 10, 10, MXCOLOR_black);
}

int main(int argc, char *argv[])
{
	(void) argc;
	(void) argv;

	/* Start the graphic system using the default mode */
	if (!mx_gfx_start(0))
		return 1;

	/* Tell what the redraw funtion is */
	mx_gfx_redraw(draw);

	/* Main loop */
	while (mx_gfx_poll()) {

		/* Move the pointer */
		mx_gfx_pointer(0, 0, 0);

		/* Loop until key is pressed */
		if (mx_gfx_key(0, 0))
			break;
	}

	return 0;
}
