/*--------------------------------------------------------------------------
 DEPUI-GFX-TK 3.0 - GPL portable source code libraries 
 http://www.deleveld.dds.nl/depui.htm
 See file docs/copying for copyright details
 ---------------------------------------------------------------------------*/

#define MXMODULE_THEME_ALL
#define MXMODULE_FONT_ALL
#define MXMODULE_DRIVER_ALL

#define MXMODULE_FILESEL
#define MXMODULE_FONTSEL
#define MXMODULE_GFXSEL
#define MXMODULE_THEMESEL
#define MXMODULE_TEXTEDITOR
#define MXMODULE_SYSMENU

#include "depui/depui.c"

static void launch_texteditor(void)
{
    MX_TEXTEDITOR* t = mx_texteditor(0);

    mx_win_rootchild(t);
    mx_defaultrect(t, 0);
    mx_layout(t, MX_LAYOUT_CENTER, (MX_OBJ*)0, 0, 0);
    mx_geometry(t);
    mx_win_dirty(t);
}

static void launch_gfxsel(void)
{
    MX_GFXSEL* g = mx_gfxsel(0);
    
    mx_win_rootchild(g);
    mx_defaultrect(g, 0);
    mx_layout(g, MX_LAYOUT_CENTER, (MX_OBJ*)0, 0, 0);
    mx_geometry(g);
    mx_win_dirty(g);
}

static void launch_fontsel(void)
{
    MX_FONTSEL* f = mx_fontsel(0);

    mx_fontsel_refresh(f);
    
    mx_win_rootchild(f);
    mx_defaultrect(f, 0);
    mx_layout(f, MX_LAYOUT_CENTER, (MX_OBJ*)0, 0, 0);
    mx_geometry(f);
    mx_win_dirty(f);
}

static void launch_themesel(void)
{
    MX_THEMESEL* t = mx_themesel(0);

    mx_themesel_refresh(t);
    
    mx_win_rootchild(t);
    mx_defaultrect(t, 0);
    mx_layout(t, MX_LAYOUT_CENTER, (MX_OBJ*)0, 0, 0);
    mx_geometry(t);
    mx_win_dirty(t);
}

int main(int argc, char *argv[])
{
    (void) argc;
    (void) argv;

    if (!mx_start())
        return EXIT_FAILURE;
        
    mx_sysmenu();

    mx_sysmenu_add("gfx mode", -1, 0, launch_gfxsel);
    mx_sysmenu_add("font", -1, 0, launch_fontsel);
    mx_sysmenu_add("theme", -1, 0, launch_themesel);
    mx_sysmenu_add("editor", -1, 0, launch_texteditor);

    return mx_execute();
}

