/* Dump a bitmap to be able to include it in code */
#define MXMODULE_BITPIXEL
#define MXMODULE_LOADTGA
#include "degfx/degfx.c"

int main(int argc, char *argv[])
{
	int i;

	for (i = 1; i < argc; i++) {
		int x, y;
		MX_BITMAP *bitmap = mx_bitmap_tga(argv[i]);

		if (bitmap) {
			int c = 0;

			printf("static MX_PIXEL %sdata[] = {\n", argv[i]);

			for (y = 0; y <= mx_h(bitmap); y++) {
				printf("    ");

				for (x = 0; x <= mx_w(bitmap); x++) {
					const MX_PIXEL p = mx_bitmap_getpixel(bitmap, x, y);
					const unsigned char r = MXR(p);
					const unsigned char g = MXG(p);
					const unsigned char b = MXB(p);
					const unsigned char t = MXT(p);

					printf("MXRGBT(%0x,%0x,%0x,%0x), ", r, g, b, t);
					if (c++ > 10)
						printf("\n");
				}
				printf("\n");
			}
			printf("\t0 };\n\n");
			printf
				("static MX_BITMAP %s = MXBITMAP_DECLARE(%sdata, %i, %i);\n\n",
				 argv[i], argv[i], mx_w(bitmap) + 1, mx_h(bitmap) + 1);

			mx_delete(bitmap);
		}
	}
	return 0;
}
